#include <bits/stdc++.h>

using namespace std;

int Query(int cvor, int L, int R, int Q_L, int Q_R, vector <int> segm)
{
    if(L >= Q_L && R <= Q_R) return segm[cvor];
    if(L > Q_R || R < Q_L) return 0;
    int mid = (L + R)/2;
    return Query(2*cvor, L, mid, Q_L, Q_R, segm) + Query(2*cvor + 1, mid + 1, R, Q_L, Q_R, segm);
}

void Update(int idx, int val, int N, vector <int>& segm)
{
    segm[idx + N] += val;
    for(int i = (idx + N)/2; i >= 1; i /= 2) segm[i] = segm[2*i] + segm[2*i + 1];
}

int broj_inv(vector <int> niz, int N)
{
    vector <int> segm(4*N + 100);
    for(int i = 0; i < 4*N + 100; i++) segm[i] = 0;
    vector <int> A;
    A.push_back(0);
    for(int i = 0; i < N; i++) A.push_back(niz[i]);
    while(__builtin_popcount(N) != 1) N++;
    int rez = 0;
    for(int i = A.size() - 1; i >= 1; i--)
    {
        rez += Query(1, 0, N - 1, 0, A[i] - 1, segm);
        Update(A[i], 1, N, segm);
    }
    return rez;
}

bool moze(long double T, vector <vector<long double> > sve, int N, int K)
{
    for(int i = 0; i < N; i++) sve[i][0] += T*sve[i][2];
    sort(sve.begin(), sve.end());
    vector <int> niz;
    for(int i = 0; i < N; i++) niz.push_back(sve[i][1]);
    int koliko = broj_inv(niz, N);
    return koliko >= K;
}

int main()
{
    int N, K;
    cin >> N >> K;
    vector <long double> X(N), V(N);
    vector < vector<long double> > sve(N);
    for(int i = 0; i < N; i++) cin >> X[i] >> V[i];
    for(int i = 0; i < N; i++) sve[i] = {X[i], i, V[i]};
    sort(sve.begin(), sve.end());
    long double L = 0, R = 2e9, EPS = 1e-6;
    while(R - L >= EPS)
    {
        long double mid = (L + R)/2;
        if(moze(mid, sve, N, K)) R = mid;
        else L = mid;
    }
    cout << fixed << showpoint << setprecision(5) << R << endl;
    return 0;
}